'--------------------------------------------------RM SafetyNet SSL Certificate Removal.vbs------------------------------------------------------

 'Script to delete and unlink the Group Policy Object (GPO) to remove the SafetyNet trusted root certificate to the network.
 'Copyright � 2016 RM. All rights reserved.
'---------------------------------------------------------------------------------------------------------------------------------------

'--------------------------------------------Global variables and constants----------------------------------------------------------------------------------------

Dim ObjRootDSE, strGPO, objGPM, objGPMDomain, objGPO, objGPMConstants, objSOM, strDNC, strCC4OUName,strDomain, _
 StrDomName, CurrentExecutionDirectory, objShell, objFSO, strLogFileName, strErrorMessage, strWarningMessage, strMessageBoxTitle, objProgressMsg,countargs,showprogress

'--------------------------------------------Global variables and constants----------------------------------------------------------------------------------------

On Error Resume Next 
  
  Initialize() 'Entry Point

  On Error GoTo 0

    
'---------------------------------------------
' Initialize the operation
'---------------------------------------------

Private Sub Initialize()
 
    On Error Resume Next
   
  '------------------------------------------------Global objects  and variables initialization----------------------------------------------
   
    strLogFileName = "RM SafetyNet SSL Certificate Removal.log"
    strGPO = "RM SafetyNet SSL Certificate"
	  strMessageBoxTitle = "RM SafetyNet SSL Certificate Removal"
    strCC4OUName = "Establishments"
    Set ObjRootDSE = GetObject("LDAP://RootDSE") 
    StrDomName = Trim(ObjRootDSE.Get("DefaultNamingContext")) 
  
    set objShell = CreateObject("Wscript.Shell")
    set objFSO = CreateObject("Scripting.FileSystemObject")

    set objGPM = CreateObject("GPMgmt.GPM")
    set objGPMConstants = objGPM.GetConstants()
    countargs=WScript.Arguments.Count
    strErrorMessage = "Error"
	  strWarningMessage = "Warning"
    
'------------------------------------------------Global objects and variables initialization----------------------------------------------
 
  Dim strMethodName
  
  strMethodName = "Initialize"	
  if countargs = 0 then
  showprogress = 1
  else
  objname  = WScript.Arguments.Item(0)
  if (objname = "/r") then
  showprogress=0
  else
  showprogress = 1
  end if
  end if
  
  if(showprogress = 1)then
  
  
  Dim intResult
  
	intResult = MsgBox("Do you want to run this script and remove GPO containing the RM SafetyNet SSL Certificate?", VBOkCancel + vbQuestion, strMessageBoxTitle )
 
	if(intResult = 2) then
     wscript.quit
	end if
	  
  ProgressMsg "The Group Policy Object (GPO) RM SafetyNet SSL Certificate will be removed . Please wait as this process may take a few minutes to complete."
  
  end if
  
  
  GetCurrentDirectory()  
  
  LogMsg "Checking if the executing user has Admin privileges..."	
  IsAdmin()  
  
  LogMsg "Getting the domain name..."	
  strDomain = GetDomainName()
  LogMsg "Domain name: " & strDomain		
	
 'Initialize the Domain object
  set objGPMDomain = objGPM.GetDomain(strDomain, "", objGPMConstants.UseAnyDC)
  
  DeleteLink()

  DeleteGPO()

  LogMsg("Sleeping for 30 sec for AD replication before applying the policies (call 'gpupdate /force')...")
  WScript.Sleep(30000) 

  LogMsg "Applying the policies..." 
  UpdatePolicies()
   
  if Err.Number then
	 Call LogError ("Error occurred.", strMethodName, strErrorMessage, false, "")
  else
     LogMsg "Successfully completed all operations."
	 ProgressMsg ""
	 Call MsgBox("The GPO has been successfully Removed. To ensure the certificate is removed from domain-joined Windows stations, either run gpupdate /force from an administrative command prompt, or restart the station.", vbInformation, strMessageBoxTitle)
  end if 
  
  
  LogMsg "---------------------End of Opearation--------------------------"
 
End Sub
  
  
  
  
	
  
 
  


'-----------------------------------------------------
' Directory in which this script is currently running
'-----------------------------------------------------

Private Function GetCurrentDirectory()

    On Error Resume Next
  
    Dim  wshell, strMethodName
    
	strMethodName = "GetCurrentDirectory"
	
    objShell.CurrentDirectory = objFSO.GetParentFolderName(Wscript.ScriptFullName)
	
    set wshell = createobject("wscript.shell")
	
    CurrentExecutionDirectory = wshell.currentdirectory
	
	LogMsg "------------------------Initializing------------------------------" 
	  
	If Err.Number then
	  Call LogError("Failed to get the current directory!", strMethodName, strErrorMessage, false, "")
	else
	  LogMsg "Successfully got the current directory: " & CurrentExecutionDirectory
    end if 
  
End Function


'-----------------------------------------------------
'Get the network domain name
'-----------------------------------------------------

Private Function GetDomainName()

  Dim Info, strMethodName 
  
  strMethodName = "GetDomainName"
  
  On Error Resume Next 
  
  Set Info = CreateObject("AdSystemInfo")  
  GetDomainName = Info.DomainDNSName   

  If Err.Number then
	Call LogError("Error while getting domain name", strMethodName, strErrorMessage, false, "")
  end if 
  
  LogMsg "Successfully got the domain name."
  
End Function 


'---------------------------------------------
' Get GPO list object
'---------------------------------------------
Private function GetGPOList()

  Dim objGPMSearchCriteria

  set objGPMSearchCriteria = objGPM.CreateSearchCriteria
  
  objGPMSearchCriteria.Add objGPMConstants.SearchPropertyGPODisplayName, objGPMConstants.SearchOpEquals, cstr(strGPO)
  
  set GetGPOList = objGPMDomain.SearchGPOs(objGPMSearchCriteria)   
  
End function


'-----------------------------------------------------------------
' Check if the user who run this script has got admin privileges
'-----------------------------------------------------------------
Private Function IsAdmin()
 
    On Error Resume Next
	
    Dim shell, strMethodName
	
	strMethodName = "IsAdmin"
	
    Set shell = CreateObject("WScript.Shell")
	
    IsAdmin = false
	
    errorLevel = shell.Run("%comspec% /c net session >nul 2>&1", 0, True)
	
    if errorLevel = 0 then
        IsAdmin = true
		LogMsg "The current user is an Administrator."
	else
	    Call LogError("The current user is not an Administrator! User should have Administrator privileges to run this script.", strMethodName, strWarningMessage, false, "")
    End If
	
	If Err.Number then
	  Call LogError("Error while checking if the user has administrator privileges", strMethodName, strErrorMessage, false, "")
    end if 
  
End Function


'---------------------------------------------
' Write a message to a log file
'---------------------------------------------
Private Sub LogMsg(sMsg)

	On Error Resume Next

	Dim a, sFile
	
	sFile = CurrentExecutionDirectory & "\" & strLogFileName
	
   	Set a = objFSO.OpenTextFile(sFile, 8, True)
	
	If Err.Number then
	  Call PopUp("Error while creating/opening log file", "Error")
    end if 
  
    a.WriteLine (Date & " " & Time & " - " & sMsg)
    	
    If Err.Number then
	  Call PopUp("Error while writing to log file", "Error")
    end if 
	
  	a.Close

End Sub


'---------------------------------------------
' Error logging
'---------------------------------------------
Private function LogError(sInsert, strMethodName, strMode, IsDeleteGPO, strDeleteGPOMessage)	 
	 
	 if Not (Err = "") Or IsNull(Err) then
	  if Not (Err.Number = 0) then
	   sMsg = strMode & "! " & "Method name: " & strMethodName & " " & "Custom Message: " & sInsert & ": Error 0x: " & CStr(Err.Number) & " Description: " & Err.Description & "." & " Exiting..."
  	   LogMsg sMsg
	  else
	    sMsg = strMode & "! " & "Method name: " & strMethodName & " " & "Custom Message: " & sInsert & ". Exiting..."
  	   LogMsg sMsg
      end if  
  	 end if
	 
	 ProgressMsg ""
	 
	 if(IsDeleteGPO) then
	   LogMsg "Deleting the GPO " & " '" & strGPO & "'" & " "  & "as " & strDeleteGPOMessage & "..."
	   DeleteGPO() 'Delete the GPO
	 end if	 
	 
	Err.Clear
	
	 on error resume next
	 Call PopUp(sInsert, strMode)
	 if Err.Number then
	      Err.Clear
	 	  wscript.quit
     end if
		
End function

'---------------------------------------------
' Pop up message box
'---------------------------------------------
Private Sub PopUp(strMessage, strMode)
    
    If(strMode = strErrorMessage) then
      Call MsgBox("There was an error removing the certificate and the process did not complete.", vbCritical, strMessageBoxTitle)
	elseIf(strMode = strWarningMessage) then
	  Call MsgBox(strMessage & VbCrLf & "Check the log file for more information at " & "'" & CurrentExecutionDirectory & "\" & strLogFileName & "'", vbExclamation, strMessageBoxTitle)	  
	End if	
	
	ProgressMsg ""
	
	Wscript.quit
	
End Sub

'---------------------------------------------
' Progress message box
'---------------------------------------------
Function ProgressMsg( strMessage)

    Set wshShell = WScript.CreateObject( "WScript.Shell" )
    strTEMP = wshShell.ExpandEnvironmentStrings( "%TEMP%" )
	
    If strMessage = "" Then
        On Error Resume Next
        objProgressMsg.Terminate( )
		
        On Error Goto 0
        Exit Function
    End If
	
    Set objFSOProgressMsg = CreateObject("Scripting.FileSystemObject")
    strTempVBS = strTEMP + "\" & "Message.vbs"

    Set objTempMessage = objFSO.CreateTextFile( strTempVBS, True )
    objTempMessage.WriteLine( "MsgBox""" & strMessage & """, 64, """ & strMessageBoxTitle & """" )
    objTempMessage.Close

    On Error Resume Next
    objProgressMsg.Terminate( )
	
    On Error Goto 0

    Set objProgressMsg = WshShell.Exec( "%windir%\system32\wscript.exe " & strTempVBS )
	
End Function


'----------------------------------------------------------------
' Delete the GPO which was created in case the GPO update fails
'----------------------------------------------------------------
Private Sub DeleteGPO()
   
   On Error Resume Next
   
   Dim strMethodName
   
   strMethodName = "DeleteGPO"

  
	'  
  'DeleteLink(objGPOList.Item(1))
 'Delete the GPO
	objGPO.Delete
	LogMsg "Successfully deleted the GPO " & "'" & strGPO & "'"
	
End Sub

'----------------------------------------------------------------
' Delete the GPO link which was created
'----------------------------------------------------------------

Private Sub DeleteLink()

 On Error Resume Next

 Dim strMethodName
   
strMethodName = "DeleteLink"

' Find the GPO
    set objGPMSearchCriteria = objGPM.CreateSearchCriteria
    objGPMSearchCriteria.Add objGPMConstants.SearchPropertyGPODisplayName, objGPMConstants.SearchOpEquals, cstr(strGPO)
    set objGPOList = objGPMDomain.SearchGPOs(objGPMSearchCriteria)
  
   if Err.Number then
	   Call LogError("Error occurred while checking if the GPO already exists:" & " " & "'" & strGPO & "'", strMethodName, strErrorMessage, false, "")
   end if 
  
  if objGPOList.Count = 1 then
   	Call LogMsg("Found the GPO" & " '" & strGPO & "'")
  elseif objGPOList.Count > 1 then
    Call LogError("Found more than one matching GPO. Count: " & objGPOList.Count, strMethodName, strWarningMessage, false, "")
  else
    Call LogError("The GPO" & " '" & strGPO & "'" &  "doesn't exist.", strMethodName, strErrorMessage, false, "")
  end if

set objGPO = objGPOList.Item(1)

set objSOM = objGPMDomain.GetSOM(StrDomName)
  
  If Err.Number Then
	   Call LogError("Error while getting the scope of management (SOM).", strMethodName, strErrorMessage, true, "error occurred while getting SOM")
   else
        LogMsg "Successfully got the scope of management (SOM) for the object " & " '" & StrDomain & "'"
  End If 
	
	if IsNull(objSOM) then
	   Call LogError("Didn't find the object " & " '" & strDomain & "'", strMethodName, strErrorMessage, true, "the object " & " '" & strDomain & "' could not be found")	   	   
	else
	   LogMsg "Found the object: " & objSOM.Name
	end if

call DeleteGPOLink(objGPO,objSOM)


End Sub

'---------------------------------------------
' Delete the GPO link
'---------------------------------------------
private Sub DeleteGPOLink(objGPOSSLCert, objSOMForDomain)
 
  On Error Resume next
  
  Dim strMethodNeme
  
  strMethodName = "DeleteGPOLink"
  
		LogMsg "The SOM Name: " & objSOMForDomain.Name
		
	       if strcomp(objSOMForDomain.Name, strDomain, vbTextCompare) = 0 then
		   
	          set colGPOLinks = objSOMForDomain.getGPOLinks( )
			   
			  If Err.Number Then
	            Call LogError("Error while getting the GPO links for" & " '" & strGPO & "'", strMethodName, strErrorMessage, true, "getting the GPO links for '" & strDomain & "' failed")
              End If 
			  
			  LogMsg "Successfully got the GPO links."
			  
			   LogMsg "The GPO link counts for " & " '" & strDomain & "':"  & colGPOLinks.Count
			   
	           for each objGPOLink in colGPOLinks
			   
	               if strcomp(objGPOLink.GPOID,objGPOSSLCert.ID,vbTextCompare) = 0 then
                     objGPOLink.Delete()
					   
                    If Err.Number Then
                        LogMsg "Error while deleting the GPO link." 
                    End If 
				  
	                  LogMsg "Successfully deleted the GPO link for " & " '" & strGPO & "'"
					   
					          Exit For ' Exit loop as we deleted the GPO link for the GPO
	
	               end if			  
	           next
	       end if  
End sub

'-----------------------------------------------------
'Update the policies by calling gpupdate /force.
'-----------------------------------------------------

Private Sub UpdatePolicies()

  set wshShell = createObject("Wscript.Shell")
  wshShell.Run "gpupdate /force", 0, true
   
  If Err.Number then
	Call LogError("Error while applying the group policies", "UpdatePolicies", strErrorMessage, false, "")
  end if 
  
 LogMsg "Applied the group policies successfully."
 
End Sub
